implementation module iTaskDB

//	super simple database creation and access based on iData
// (c) mjp 2007 

import iTasks, iDataFormlib, StdEnv, iDataTrivial

::DBid a :== (String,Lifespan)

// Common db access

readDB	:: (DBid a) 		-> Task a | iData a
readDB 	name 		= appHSt (DB name id)

writeDB	:: (DBid a) a 	-> Task a | iData a
writeDB name value 	= appHSt (DB name (const value))

readDB2	:: (DBid a) 		-> Task a | iData a
readDB2 name 		= appHSt2 (DB name id)

DB :: (DBid a) (a -> a) *HSt -> (a,*HSt) | iData a
DB (name,storageKind) fun hst 
# (form,hst)	= mkStoreForm (Init,nFormId (db_prefix +++ name) createDefault <@ storageKind) fun hst
= (form.value,hst)

mkDBid :: String Lifespan -> (DBid a)
mkDBid s Database 	= (s,Database)
mkDBid s TxtFile	= (s,TxtFile)		// DataFile not yet implemented
mkDBid s attr		= abort ("Database created with illegal attribute: " <+++ attr)